/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.base.TTLObject;
import java.io.File;
import java.io.FileInputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Properties;

public class JVMSystemConstants {
    public static final String DISABLED_ME = "filenet.vw.base.JVMSystemConstants.disabled";
    public static final String BOOTSTRAP_CEURI = "filenet.pe.bootstrap.ceuri";
    public static final String BYPASSS_CEURI = "filenet.pe.bypass.ceuri";
    public static final String RPC_TIMEOUT_PROPERTY = "filenet.vw.api.rpc.timeout";
    public static final String PE_RPC_ID_CACHE_TTL = "filenet.pe.id.cache.ttl";
    public static final String PE_RPC_VWSESSION_CACHE_TTL = "filenet.pe.vwsession.cache.ttl";
    public static final String PE_RPC_IOR_CACHE_TTL = "filenet.pe.ior.cache.ttl.in.seconds";
    public static final String RPC_CORBA_RETRY_SLEEP_PROPERTY = "filenet.pe.corba.retry.sleep";
    public static final String RPC_USE_NAMESERVICE_PROPERTY = "filenet.vw.api.usens";
    public static final String RPC_USE_NEW_TOKEN = "filenet.pe.new.token";
    public static final String CM_CONNECTIONPOINT = "filenet.pe.cm.connectionPoint";
    public static final String CM_JMS_ORACLE = "filenet.pe.cm.OJMS";
    public static final String CM_ADAPTOR_MAX_POLLING_INTERVAL = "filenet.pe.cm.max.polling.interval";
    public static final String CM_ADAPTOR_POLLING_INCREMENT = "filenet.pe.cm.polling.increment";
    public static final String EVENTLOG_LEVEL = "filenet.pe.eventlog.level";
    public static final String[] EVENTLOG_LEVEL_VALUES = new String[]{"INFO", "WARNING", "SEVERE"};
    public static final String CM_ADAPTOR_SINGLE_DISPATCHER = "filenet.pe.cm.adaptor.single.dispatcher.";
    public static final String CM_ADAPTOR_DISPATCHER_NEXTWORKER_TIMEOUT_INSEC = "filenet.pe.cm.adaptor.dispatcher.nextworker.timeout.in.seconds";
    public static final long CM_ADAPTOR_DISPATCHER_NEXTWORKER_TIMEOUT_INSEC_DEFAULT_VALUE = 300L;
    public static final String CM_ADAPTOR_BUFFER_SIZE = "filenet.pe.cm.buffer.size";
    public static final String CM_35_ADAPTOR_EXCEPTION_POLLING_INTERVAL = "filenet.PE.exception.polling.interval.ms";
    public static final String CM_ADAPTOR_EXCEPTION_POLLING_INTERVAL = "filenet.pe.cm.exception.polling.interval";
    public static final String CM_WS_ATT_USE_STREAM = "filenet.ws.att.useStream";
    public static final String CM_WS_NUM_THREAD = "filenet.ws.num.threads";
    public static final String WS_WSDL_TIMEOUT = "filenet.ws.wsdl.timeout";
    public static final String WS_SSL_AUTOTRUST = "filenet.ws.ssl.autotrust";
    public static final String WS_DISABLED_PROPERTY = "filenet.PE.NOWS";
    public static final String WCMAPICONFIG_PROPERTIES = "filenet.wcmapiconfig";
    public static final String CM_CEOPS_AUTO_CLASSIFY = "filenet.contentops.ceoperations.AutoClassify";
    public static final String AE_TASKMAN_CM_ADVANCED = "filenet.ae.taskman.cm.advanced";
    public static final String AE_TASKMAN_CM_NO_FIXING_WSDL4J = "filenet.ae.taskman.cm.no.wsdl4j.fix";
    public static final String JAVA_CLASSPATH = "java.class.path";
    public static final String JAVA_RMI_SERVER_CODEBASE = "java.rmi.server.codebase";
    public static final String JAVA_NAMING_FACTORY_INITIAL = "java.naming.factory.initial";
    public static final String JAVA_NAMING_PROVIDER_URL = "java.naming.provider.url";
    public static final String JAVA_SECURITY_AUTH_LOGIN_CONFIG = "java.security.auth.login.config";
    public static final String FILENET_JAVA_NAMING_PROVIDER_URL = "filenet.naming.provider.url";
    public static final String VWSESSIONTIMEOUT = "filenet.ws.listener.utils.VWSessionTimeout";
    public static final String VWSESSIONCACHETIMEOUT = "filenet.ws.listener.utils.VWSessionCacheTimeout";
    public static final String ORB_SINGLETON = "filenet.pe.peorb.singleton";
    public static final String ORB_POOL_GUARD = "filenet.pe.peorb.pool.guard";
    public static final String ORB_POOL_MIN = "filenet.pe.peorb.pool.min";
    public static final String ORB_POOL_MAX = "filenet.pe.peorb.pool.max";
    public static final String LOGGING_FILE_CHECK_INTERVAL = "filenet.vw.base.logging.checkfile.interval";
    public static final long LOGGING_FILE_CHECK_INTERVAL_DEFAULT = 60000L;
    public static final String ENCRYPTION_KEYSTORE_PATH = "filenet.pe.encryption.keystore.path";
    public static final String ENCRYPTION_KEYSTORE_PW = "filenet.pe.encryption.keystore.pw";
    public static final String ENCRYPTION_KEYSTORE_KEYPW = "filenet.pe.encryption.keystore.keypw";
    public static final String ENCRYPTION_KEYSTORE_KEYALIAS = "filenet.pe.encryption.keystore.keyalias";
    public static final String PE_ORBPARAMS_PREFIX = "filenet.pe.peorb.ORBParams.";
    public static final String WPS_UID_FILENAME = "filenet.wps.uid.filename";
    public static final String ADAPTORS_UID_FILENAME = "filenet.adaptors.uid.filename";
    public static final String LISTENER_LOCATION_SYSTEM_PROPERTY = "filenet.ws.listener.properties.location";
    public static final String HFP_CM_BASE_PATH = "filenet.cm.basePath";
    public static final String HFP_CM_BASE_URL = "filenet.cm.baseURL";
    public static final String HFP_CM_MAIL_DOMAIN = "filenet.cm.mailDomain";
    public static final String HFP_CM_MAIL_FROM = "filenet.cm.mailFrom";
    public static final String HFP_CM_OBJECT_STORE_NAME = "filenet.cm.objectStoreName";
    public static final String P8BPMWSBROKER_READ_TIMEOUT = "filenet.pe.p8bpmwsbroker.read.timeout";
    public static final String HTTPCLIENT_ENABLED = "filenet.pe.api.httpclient.enabled";
    private static HashMap SEEN_SYS_PROPS = new HashMap(20);
    private static String CONFIG_FILENAME = null;
    private static long CONFIG_FILELASTMODIFIED = -1L;
    private static Properties p8bpmproperties;

    public static String _get_FILE_DATE() {
        return "$Date:   18 Mar 2009 17:00:22  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.15  $";
    }

    private static final String _getPrivilegedSystemProperty(String propName) {
        final String fpropName = propName;
        String res = null;
        TTLObject curVal = (TTLObject)SEEN_SYS_PROPS.get(propName);
        if (curVal != null) {
            return (String)curVal.getObject();
        }
        res = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(fpropName);
            }
        });
        SEEN_SYS_PROPS.put(propName, new TTLObject(res, null, 1440L, 0));
        return res;
    }

    private static synchronized String getPropertyFromFile(String propertyName, String defaultValue) {
        String propValue = null;
        final String fPropName = propertyName;
        if (CONFIG_FILENAME != null) {
            propValue = (String)AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public Object run() {
                    File f = new File(CONFIG_FILENAME);
                    if (!f.exists()) return (String)p8bpmproperties.get(fPropName);
                    long lastModified = f.lastModified();
                    if (CONFIG_FILELASTMODIFIED != -1L) {
                        if (lastModified <= CONFIG_FILELASTMODIFIED) return (String)p8bpmproperties.get(fPropName);
                    }
                    CONFIG_FILELASTMODIFIED = lastModified;
                    FileInputStream in = null;
                    in = new FileInputStream(f);
                    p8bpmproperties.load(in);
                    Object var7_5 = null;
                    if (in == null) return (String)p8bpmproperties.get(fPropName);
                    try {
                        in.close();
                        return (String)p8bpmproperties.get(fPropName);
                    }
                    catch (Exception e2) {}
                    return (String)p8bpmproperties.get(fPropName);
                    {
                        catch (Exception e) {
                            Object var7_6 = null;
                            if (in == null) return (String)p8bpmproperties.get(fPropName);
                            try {
                                in.close();
                                return (String)p8bpmproperties.get(fPropName);
                            }
                            catch (Exception e2) {}
                            return (String)p8bpmproperties.get(fPropName);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        if (in == null) throw throwable;
                        try {
                            in.close();
                            throw throwable;
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            });
        }
        if (propValue == null) {
            return defaultValue;
        }
        return propValue;
    }

    public static synchronized Properties get_p8bpmsystems_properties() {
        if (CONFIG_FILENAME != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public Object run() {
                    File f = new File(CONFIG_FILENAME);
                    if (!f.exists()) return null;
                    long lastModified = f.lastModified();
                    if (CONFIG_FILELASTMODIFIED != -1L && lastModified <= CONFIG_FILELASTMODIFIED) return null;
                    CONFIG_FILELASTMODIFIED = lastModified;
                    FileInputStream in = null;
                    in = new FileInputStream(f);
                    p8bpmproperties.load(in);
                    Object var7_4 = null;
                    if (in == null) return null;
                    try {
                        in.close();
                        return null;
                    }
                    catch (Exception e2) {}
                    return null;
                    {
                        catch (Exception e) {
                            Object var7_5 = null;
                            if (in == null) return null;
                            try {
                                in.close();
                                return null;
                            }
                            catch (Exception e2) {}
                            return null;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_6 = null;
                        if (in == null) throw throwable;
                        try {
                            in.close();
                            throw throwable;
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            });
        }
        return p8bpmproperties;
    }

    public static final String GetPrivilegedSystemPropertyWithDefault(String propName, String defaultValue) {
        String s = null;
        try {
            s = JVMSystemConstants._getPrivilegedSystemProperty(propName);
        }
        catch (Throwable t) {
            s = null;
        }
        if (s == null) {
            s = JVMSystemConstants.getPropertyFromFile(propName, defaultValue);
        }
        return s;
    }

    public static final long GetLongPrivilegedSystemPropertyWithDefault(String propName, long defaultValue) {
        String s = JVMSystemConstants.GetPrivilegedSystemProperty(propName);
        if (s == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(s);
        }
        catch (Throwable t) {
            return defaultValue;
        }
    }

    public static final String GetPrivilegedSystemProperty(String propName) {
        return JVMSystemConstants.GetPrivilegedSystemPropertyWithDefault(propName, null);
    }

    public static final String SetPrivilegedSystemProperty(String propName, String propValue) {
        final String fpropName = propName;
        final String fpropValue = propValue;
        String res = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String res = System.getProperty(fpropName);
                System.setProperty(fpropName, fpropValue);
                return res;
            }
        });
        TTLObject obj = (TTLObject)SEEN_SYS_PROPS.get(fpropName);
        if (obj == null) {
            SEEN_SYS_PROPS.put(fpropName, new TTLObject(fpropValue, null, 1440L, 0));
        } else {
            if (res == null) {
                res = (String)obj.getObject();
            }
            obj.setObject(fpropValue);
        }
        return res;
    }

    public static void main(String[] args) {
        try {
            int i;
            int nArgs = args == null ? 0 : args.length;
            for (i = 0; i < nArgs; ++i) {
                System.out.println(args[0] + "=" + JVMSystemConstants.GetPrivilegedSystemProperty(args[0]));
            }
            System.out.println("Pause to test the updating of values in p8bpmsystem.properties");
            System.in.read();
            for (i = 0; i < nArgs; ++i) {
                System.out.println(args[0] + "=" + JVMSystemConstants.GetPrivilegedSystemProperty(args[0]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            String javaDir;
            boolean doNotUseFile;
            boolean bl = doNotUseFile = JVMSystemConstants._getPrivilegedSystemProperty(DISABLED_ME) != null;
            if (!doNotUseFile && (javaDir = JVMSystemConstants._getPrivilegedSystemProperty("java.home")) != null) {
                File parentLib = new File(javaDir, "lib");
                File f = new File(parentLib, "p8bpmsystems.properties");
                CONFIG_FILENAME = f.getCanonicalPath();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        p8bpmproperties = new Properties();
    }
}

